/*******************************************************************
*
*  DESCRIPTION: Food Court Model
*
*  AUTHOR: Shagun Goel
*
*
*******************************************************************/

/** include files **/
#include "cashier.h"      // class cashier
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include <stdlib.h>

/** public functions **/

/*******************************************************************
* Function Name: cashier
* Description: 
********************************************************************/
cashier::cashier( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, request( addInputPort( "request" ) )
, out( addOutputPort( "out" ) )
, beReady( addOutputPort( "beReady" ) )
{
string counters( MainSimulator::Instance().getParameter( description(), "counters" ) ) ;

max_counters = atoi(counters.data());

if (max_counters <= 0)
	max_counters = 10;

reqList = new int[max_counters];
MASSERT (reqList != 0);

//Display information to user
cout<<endl<<"The cashier can be connected with ";
if (max_counters == 1)
	cout<<"only "<<max_counters<<" counter";
else
	cout<<max_counters<<" counters";
cout<<endl<<endl;
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition: 
********************************************************************/
Model &cashier::initFunction()
{

for (int counter_id=0; counter_id<max_counters; counter_id++)
	reqList[counter_id] = 0;

request_count = 0;
elements.erase( elements.begin(), elements.end() ) ;

return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &cashier::externalFunction( const ExternalMessage &msg )
{
if( msg.port() == in )
	{
	elements.push_back( msg.value() ) ;
      	if ((elements.size() == 1) && (request_count > 0))
		holdIn( active, Time::Zero);
	else if (request_count == 0)
		passivate();
	}

if( (msg.port() == request ) && (msg.value() >= 0) && (msg.value() < max_counters))
	{
	reqList[(int)msg.value()] = 1;
	
	request_count++;
	
	if ((request_count == 1) && (elements.size() > 0))
		holdIn( active, Time::Zero);
	
	else if (elements.size() == 0)
		passivate();	
	}

return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &cashier::internalFunction( const InternalMessage & )
{

elements.pop_front();

if ((request_count >0) && (elements.size() > 0))
	holdIn( active, Time::Zero);
else
	passivate();

return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &cashier::outputFunction( const InternalMessage &msg )
{
int counter_id = get_counter_id();

if (counter_id >= 0)
	{
	sendOutput( msg.time(), beReady, (double)counter_id); // make counter ready
	sendOutput( msg.time(), out, elements.front());  //send data to desired server
	}

return *this ;
}
/*******************************************************************
* Function Name: get_counter_id
* Description: 
********************************************************************/

int cashier::get_counter_id()
{

for (int counter_id=0; counter_id<max_counters; counter_id++)
	{
	if (reqList[counter_id] == 1) //this counter has request
		{
		reqList[counter_id] = 0;
		request_count--;
		return counter_id; // found counter
		}
	}
return -1;
}
